<?php
/**
 * Get Service Details by ID
 * Returns service information in JSON format
 */

header('Content-Type: application/json');

require_once 'config.php';

// Get service ID from request
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid service ID']);
    exit();
}

// Fetch service from database
$query = "SELECT id, name, category, description, image, price, duration, status FROM services WHERE id = ? AND status = 'active'";
$stmt = $conn->prepare($query);

if (!$stmt) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $conn->error]);
    exit();
}

$stmt->bind_param('i', $id);

if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Execution error: ' . $stmt->error]);
    exit();
}

$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(404);
    echo json_encode(['success' => false, 'message' => 'Service not found']);
    exit();
}

$service = $result->fetch_assoc();

// Return service data
echo json_encode([
    'success' => true,
    'data' => [
        'id' => $service['id'],
        'name' => $service['name'],
        'category' => $service['category'],
        'description' => $service['description'],
        'image' => $service['image'] ? 'assets/uploads/services/' . htmlspecialchars($service['image']) : 'assets/img/placeholder.jpg',
        'price' => $service['price'],
        'duration' => $service['duration'] ? $service['duration'] . ' mins' : '60 mins'
    ]
]);

$stmt->close();
?>
